<?php

class digitrack
{ // BEGIN class digistat

/* 
CLASSE GENERALE DE CONTROLE DIGITRACK

exemples d'usage

$stat = new digistat('2007-05-01','3 days');

info sur la journée
$stat->get_day_info();

info sur un user
$stat->get_user_info($id); 
$html->html .= $stat->show_user_info();


*/


	// variables
	// constructor
	function digitrack($start = '',$end = '',$ln = 'french')
	{ // BEGIN constructor
	$this->tf = 'Y-m-d H:i:s';
	$this->sf = 'd/m/y H:i';
  $this->ln = $ln;
  $this->labels = parse_ini_file($this->ln.'.ini');
  	
  $this->start_date = date('Y-m-d H:i:s',strtotime($start));
  $this->start_time = strtotime($this->start_date);
  $this->start_day = substr($this->start_date,0,10); 
  
  // end est une string ou une date ou un nombre de jours 
   if(stristr($end,'hour') || stristr($end,'month') || stristr($end,'day') || stristr($end,'year')) $this->end_date = date($this->tf ,strtotime("$this->start_date $end"));
   elseif(strlen($end) == 10) $this->end_date = date($this->tf ,strtotime($end));  
   else $this->end_date = date($this->tf ,mktime(0, 0, 0, date('m',strtotime($start)), date('d',strtotime($start))+$end,  date('Y',strtotime($start))));
   $this->end_time = strtotime($this->start_date);
   $this->end_day = substr($this->end_date,0,10);
   
	} // END constructor
	
   
// GENERIQUES

  function href_link($data,$length = 70)
  {
   
  if($data['name'] != '') $name = (strlen($data['name']) > $length) ? substr($data['name'],0,$length).'...' : $data['name'];
  elseif(isset($data['moteur']) && $data['moteur'] != '') $name = $data['moteur'];
  elseif(isset($data['source'])) $name = $data['source']; 
  else $name = " Nom ";
   
  $type = $data['type'];
  $link = '<a href="'.HTTP_SERVER.'/index.php?mode='.$type.'&id='.$data['id'].'">'.$name.'</a>';
  return $link;  
  }
  
  function menu()
    {
    // affiche le menu haut dans toutes les pages
    $string = '
    <div id="menu">
    <h2>Menu</h2>
    <ul>
      <li><a href="index.php?mode=validation">Validation des nouveaux utilisateurs</a></li>
	<li><a href="index.php?mode=validation&action=users_updates">Validation des modifications des profils des utilisateurs</a></li>
      <li><a href="index.php?mode=validation&action=view">Voir les utilisateurs valid&eacute;s / export&eacute;s</a></li>
      <li><a href="index.php?mode=user">Suivi d\'activit&eacute; des utilisateurs enregistr&eacute;s</a></li>
      <li><a href="index.php?mode=validation&action=print">Imprimer la liste des contacts entrants &agrave; valider</a></li>
      <li><a href="index.php?mode=event">Voir les inscrits aux évènements</a></li>      
      <li><a href="index.php?mode=download">Voir les downloads</a></li> 
    </ul>
    </div>';
    return $string;
    
    }
    
  function open_stat($object)
    {
    $object->html = '
    <div class="data" id="'.$object->div_id.'">
    ';
    }
  function close_stat($object)
    {
    $object->html .= '
    </div><!--//data-->
    ';
    
    global $html;
    $html->html .= $object->html;
    
    }
  function add_bloc($object,$title,$data)
    {
    // $track->add_bloc($stat,'days',$chart->chart);
    $object->html .= '
    <div class="bloc">
    <h2>'.$title.'</h2>
    ' . $data . '
    </div><!--//bloc-->';
    }   
      
	function get_split_traffic($mode = 'day')
	 {
   foreach($this->split($mode) as $start) 
     {
     $end = date($this->tf,strtotime("$start + 1 $mode"));
     $result = $this->sqli("SELECT COUNT(id) as ct FROM events WHERE event_date BETWEEN '$start' AND '$end'");
      $this->result[$start] = $result->ct;     
     }
   
   }
  function fetch_referrers($datas,$limit=10)
  {
  if(count($datas) > 1)
  {
  foreach($datas as $n)
    {
    
    $array[] = array(
    'type' => 'ref', 
    'id' => (int) $n->id,
    'name' => utf8_encode((string) $n->mot), 
    'source' => (string) $n->source,
    'moteur' => (string) $n->moteurs,
    'value' => (int) $n->ct);
    }
  }
  else $array = array();
  return $array;
  }
  
  
  function show_referrers($referrers,$limit = 20)
  {
  $string = '
  <div class="bloc">
  <h3>'.$this->labels['referrers'].'</h3>';
  
    $string .= '
    <table cellspacing="0">
      <tr>
        <th width="200px">'.$this->labels['ref_lien'].'</th>
        <th width="100px">'.$this->labels['ref_source'].'</th>
        <th width="200px">'.$this->labels['ref_moteur'].'</th>
        <th width="200px">'.$this->labels['ref_name'].'</th>
        <th width="100px">'.$this->labels['ref_value'].'</th>
      </tr>';
    $i = 0;
    foreach($referrers as $line)
      {
      $i++;
      $string .= '
      <tr>
        <td>'.$this->href_link($line).'</td>
        <td>'.$line['source'].'</td>
        <td>'.$line['moteur'].'</td>
        <td>'.$line['name'].'</td>
        <td>'.$line['value'].'</td>
      </tr>';
      if($i > $limit) break;
      }
    $string .= '
    </table>';
  
   $string .= '
   </div><!--//bloc-->';  
   return $string;
  }	

  function fetch_ressources($datas)
    {
    foreach($datas as $n) 
      { 
      if(isset($n->name) && isset($n->ct))
      {
      $name = (string) $n->name;
      $value = (int) $n->ct;
      $id = (int) $n->id;
      if(isset($n->total_index)) $array[] = array('type' => 'ressource', 'id' => $id,'name' => $name,'value' => $value,'total_index' => (int) $n->total_index,'d15_index' => (int) $n->d15_index);
      else $array[] = array('type' => 'ressource', 'id' => $id,'name' => $name,'value' => $value);
      }  
      }
    return $array;
    }
      
  function show_ressources($ressources,$limit=20,$colonnes = 1)
    {
    
  $string = '
  <div class="bloc">';
   if($colonnes) $string .= '
   <h3>'.$this->labels['top_ressources'].'</h3>';

    if($colonnes)
    $string .= '
    <table cellspacing="0">
      <tr><th width="600px">'.$this->labels['ressource_name'].'</th><th>'.$this->labels['n_consults'].'</th></tr>';
    else
    $string .= '
    <table cellspacing="0">
      <tr><th width="670px">'.$this->labels['full_ressources'].'</th></tr>';
    
    $i = 0;
    foreach($ressources as $line)
      {
      $i++;
      if($colonnes)
        $string .= '
      <tr><td>'.$this->href_link($line).'</td><td align="center">'.$line['value'].'</td></tr>';
      else
        $string .= '
      <tr><td>'.$this->href_link($line,300).'</td></tr>';
      if($i > $limit) break;
      }
    $string .= '
    </table>';
   $string .= '
   </div><!--//bloc-->';  
   return $string;  
    }
    
    
  function fetch_users($users,$limit=10)
    {
    foreach($users as $n) 
    { 
      if(isset($n->ct))
      {
      if(!isset($n->name)) $n->name = $this->get_user_name((int) $n->id);
      $name = (string) $n->name;
      $value = (int) $n->ct;
      $id = (int) $n->id;
      $array[] = array('type' => 'user', 'id' => $id,'name' => $name,'value' => $value,'total_index' => (int) $n->total_index,'d15_index' => (int) $n->d15_index);
      //else $array[] = array('type' => substr($type,4,-1), 'id' => $id,'name' => $name,'value' => $value);
      }  
    }
    return $array;
    }    
  function show_users($users,$limit=10,$colonnes = 1)
    {
   $string = '
   <div class="bloc">';
   if($colonnes) $string .= '
   <h3>'.$this->labels['top_users'].'</h3>';
   
   
    $string .= '
    <table cellspacing="0">
      <tr>';
    
    if($colonnes) $string .= '
        <th width="350px">'.$this->labels['user_name'].'</th>
        <th valign="top" width="150px">'.$this->labels['n_views'].'</th>
        <th valign="top" width="100px">'.str_replace('&nbsp;','<br />',$this->labels['d15_index']).'</th>
        <th valign="top" width="70px">'.$this->labels['total_index'].'</th></tr>';
    else $string .= '
    <th width="670px">'.$this->labels['full_users'].'</th></tr>';
    
    
        $i = 0;
    foreach($users as $line)
     {
     $i++;
      if($colonnes)
        $string .= '
      <tr><td>'.$this->href_link($line).'</td><td>'.$line['value'].'</td><td>'.$line['total_index'].'</td><td>'.$line['d15_index'].'</td></tr>';
      else 
        $string .= '
      <tr><td>'.$this->href_link($line,300).'</td></tr>';
      
      if($i > $limit) break;
      }
    $string .= '
    </table>';
    return $string;
    }

function get_user_name($id)
  {
  $user_data = $this->sqli("SELECT d.VALUE, f.NAME FROM ".TABLE_CIMY_DATA." d LEFT JOIN ".TABLE_CIMY_FIELDS." f ON f.ID = d.FIELD_ID WHERE d.USER_ID = '$id' AND d.FIELD_ID IN ('11','12','20')");
  if(is_array($user_data)) foreach($user_data as $data) $tmp[$id][$data->NAME] = $data->VALUE;
  $return = $tmp[$id]['FIRST_NAME'] .' '  .$tmp[$id]['LAST_NAME']  .' ('  . utf8_encode(html_entity_decode($tmp[$id]['COMPANY']))  .')';  
  return $return;
  }
/* FONCTIONS d'APERCU GLOBAL */
  /*function get_full()
    {
	//grosse requete a modifier
    $this->datas = $this->sqli("SELECT DISTINCT e.id, e.user_id, e.ressource_id, e.event_date, r.ressource_url
FROM ".TABLE_EVENTS." e
LEFT JOIN ".TABLE_RESSOURCES." r ON r.id = e.ressource_id
ORDER BY e.event_date DESC");

  foreach($this->datas as $event)
    {
    $date = substr($event->event_date,0,10);
    $date = $this->href_link(array('type' => 'day','id'=> $date,'name' => $date));
    $this->full_dates[$date] = 1;
    
    if(!isset($this->users[$event->user_id])) $this->users[$event->user_id] = $this->get_user_name($event->user_id);
      
    if($event->ressource_url != '') 
      $this->full_ressources[] = array(
        'type' => 'ressource',
        'id' => $event->ressource_id,
        'name' => $event->ressource_url
        );
    if($this->users[$event->user_id] && $this->users[$event->user_id] != '' && !empty($event->ressource_url)) 
      $this->full_users[] = array(
        'type' => 'user',
        'id' => $event->user_id,
        'name' => $this->users[$event->user_id]. $this->labels['a_vu']. $event->ressource_url); 
    }
    }*/


	function show_full()
	 {
	 //$this->get_full();
	 $this->aff_resu_stats_jours();
   $string = '';
   $string .= '
   <div class="data" id="user">
   <h1>'.$this->labels['full'].'</h1>';
   
   $string .= '
   <div class="bloc">
   <h2>'.$this->labels['full_days'].'</h2>';
   $string.='Selection de l\'année et du mois';
   $string.='<br>';
   $string.=$this->combo_mois(date("m"));
   //$this->combo_mois(date("m"));
   if(isset($this->full_dates) && $this->full_dates!="" && $this->full_dates!='')
		foreach($this->full_dates as $date => $rien) $string .= "<br />$date";
   else
		$string.="&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Aucun r&eacute;sultat.<br/>";
   $string .= '
   </div>';


	if(is_array($this->full_users)) $string .= $this->show_users($this->full_users,20,0);
	if(is_array($this->full_ressources)) $string .= $this->show_ressources($this->full_ressources,20,0);


   
   $string .= '
   </div>';
   
   return $string;
   }
   

  
/* GENERIQUES */	


	function datation($time,$recur = 0)
	 {
	 $stamp = time() - $time;
	 if($stamp < 80) $string = "1 minute";
	 elseif($stamp < 3400) $string = round($stamp / 60,0)." minutes";
	 elseif($stamp < 7200 ) $string = ($this->datation($time + 3600) != '') ? "1 heure et ".$this->datation($time + 3600,1): "1 heure";
	 elseif($stamp < 84000) $string = round($stamp / 3600,0)." heures";
	 elseif($stamp < 172800) $string = ($this->datation($time + 86400) != '') ? "1 jour et ". $this->datation($time + 86400,1): "1 jour";
	 else $string = round($stamp / 86400)." jours";

	 if(!$recur && $string != '') $string = '<small>'.$this->labels['since'].'</small>'.$string;
	 return $string;
	 }

	function split($mode = 'day')
	 {
	 if($mode == 'day') for($day = $this->start_date; $day < $this->end_date; $day = date($this->tf,strtotime("$day + 1 day")) ) $array[] = $day;
   if($mode == 'hour') for($day = $this->start_date; $day < $this->end_date; $day = date($this->tf,strtotime("$day + 1 hour")) ) $array[] = $day;
   return $array;
   }

 function sqli($string) 
 {
 global $sql;
 $this->queries[$string] = array(); // on logge dans l'objet pour debug
 $res = $sql->query($string) or ($this->errors[$string][] = $sql->error); /* on execute la query */ 
 
 if(stristr($string,'SELECT') && !is_object($res)) { $this->errors[] = "ECHEC NON OBJET : $string"; return false; }
 
 
 if(is_object($res) &&  stristr($string,"SELECT"))
  { 
  while($line = $res->fetch_object()) @$resultat[] = $line;
  if(count($resultat) == 1) $resultat = $resultat[0]; 
  $this->queries[$string] = $resultat; return $resultat;
  }
 elseif(is_object($res) && $res = $res->insert_id) { $this->queries[$string] = $res; return $res; }
 else { $this->queries[$string] = 'phase 3';return false; }
 }
 
 //POUR LA GESTION DES DATES:
	
	
	function combo_mois ($mois="")
	{   
		$moisentier=array("Janvier","Fevrier","Mars","Avril","Mai","Juin", "Juillet", "Aout", "Septembre", "Octobre", "Novembre", "Decembre");
		$moissql=array("01","02","03","04","05","06", "07", "08", "09", "10", "11", "12");	
		$combo="";
	    $combo.="<form name='stats_jours' id='stats_jours' method='GET' action='index.php?mode=user'> ";
		$combo.="<input type='hidden' name='mode' id='mode' value='user'>";
		$combo.="<br><br>Mois: <select name='month' id='month'>";
		$i=0;
		while ($moisentier[$i]){
			if ($moissql[$i]==$current_month){
				$selected="selected";
			}else{
				$selected="";
			}
			$combo.="<option $selected value='".$moissql[$i]."'> ".$moisentier[$i]." </option>";
			$i++;
		}
		$combo.="</select>";

		$combo.="Ann&eacute;e: <select name='year' id='year'>";
		$i=0;$year=2007;
		do{
			
			$combo.="<option value='$year'> $year</option>";			
			$year++;
		}while ($year < 2010);
		$combo.="</select>&nbsp;&nbsp;
		<input type='submit' value=' VOIR '></form>";
		return $combo;
	}
	//---Les années------//
	function aff_resu_stats_jours()
	{
		$date="";
		$this->full_dates="";
	    //if( isset($_GET['year']) && isset($_GET['month']) )
		//{
			if(!isset($_GET['year']))
				$_GET['year']=date("Y");
			if(!isset($_GET['month']))
				$_GET['month']=date("m");
			$this->datas="";
			$this->datas = $this->sqli("SELECT DISTINCT e.id, e.user_id, e.ressource_id, e.event_date, r.ressource_url
					FROM ".TABLE_EVENTS." e
					LEFT JOIN ".TABLE_RESSOURCES." r ON r.id = e.ressource_id
					WHERE MONTH(e.event_date)='".$_GET['month']."' AND YEAR(e.event_date)='".$_GET['year']."'
					ORDER BY e.event_date DESC");
	
			if($this->datas!="" || $this->datas!=null)
			{
			foreach($this->datas as $event)
		    {
			    $date = substr($event->event_date,0,10);
			    $date = $this->href_link(array('type' => 'day','id'=> $date,'name' => $date));
			    $this->full_dates[$date] = 1;
			    
			    if(!isset($this->users[$event->user_id])) $this->users[$event->user_id] = $this->get_user_name($event->user_id);
		
			}}
		//}
		$this->datas="";
		$this->datas = $this->sqli("SELECT DISTINCT e.id, e.user_id, e.ressource_id, e.event_date, r.ressource_url
						FROM ".TABLE_EVENTS." e
						LEFT JOIN ".TABLE_RESSOURCES." r ON r.id = e.ressource_id
						ORDER BY e.event_date DESC LIMIT 0 , 20");
		foreach($this->datas as $event)
		    {
		    
			    if(!isset($this->users[$event->user_id])) $this->users[$event->user_id] = $this->get_user_name($event->user_id);
			      
			    if($event->ressource_url != '') 
			      $this->full_ressources[] = array(
			        'type' => 'ressource',
			        'id' => $event->ressource_id,
		        'name' => $event->ressource_url
		        );
			    if($this->users[$event->user_id] && $this->users[$event->user_id] != '' && !empty($event->ressource_url)) 
			      $this->full_users[] = array(
			        'type' => 'user',
			        'id' => $event->user_id,
			        'name' => $this->users[$event->user_id]. $this->labels['a_vu']. $event->ressource_url);
	    
			
			}
					
		
    }
	
	
} // END class digistat

?>
